import {
    View,
    Text,
    TouchableOpacity,
    KeyboardAvoidingView,
    ScrollView,
    Pressable,
    SafeAreaView,
    StyleSheet,
    Platform
} from "react-native";
import React, { useState } from "react";
import { ProfileStyles } from "../../Profile/ProfileStyle";
import { filtersStyles } from "./filtersStyle";
import CommonStyles from "../../Utilities/CommonStyles/CommonStyles";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { EditProfileStyle } from "../../Profile/EditProfile/StyleEditProfile";
import FilterInput from "./FilterInput";
import FilterSelect from "./FilterSelect";
import SelectBrand from "./SelectBrand";
import { addNewAddressStyle } from "../../Profile/Address/AddNewAddress/AddNewAddressStyle";
import { useDispatch, useSelector } from "react-redux";
import { manageFilter } from "../utils/filterAttribute";
import CustomRating from "../../Utilities/CustomRating/CustomRating";
import BackIcon from "../../../assets/svgs/backButton.svg";
import { round } from "../../../helper/ratingRound";
import { InOnScreenLoader } from "../../ShoppingCart/ShoppingCart";
import useAuth from "../../../hooks/useAuth";
import { getsearchProducts } from "../../../redux/slices/searchProducts/searchProducts";
import useLangTranslation from "../../../hooks/useLangTranslation";
import gapStyle from "../../Utilities/CommonStyles/gap.style";
import {
    createAttributePostUrl,
    createFilterablePostUrl,
    replaceStringByRange,
} from "./filterHelper";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const Filters = (props) => {
    const { trans } = useLangTranslation();
    const {
        setFilterModal,
        URL,
        sortByArray,
        setSortBy,
        stars,
        setStars,
        minPrice,
        setMin_Price,
        maxPrice,
        setMax_Price,
        postUrl,
    } = props || {};
    const { filterable, filter_applied, loading } = useSelector(
        (state) => state.searchProducts
    );
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    let { prop, price_range } = manageFilter(filterable, "", filter_applied);
    const [attributeKey, setattributeKey] = useState(prop);
    const ratingCompleted = (r) => {
        let key = "&rating="
        let rating = `${key}${round(r)}`;
        let ratingIndex = postUrl?.current?.indexOf(key);
        if(ratingIndex == -1) {
            postUrl.current = postUrl?.current + rating
        } else {
            let ratingValueIndex = ratingIndex + key.length;
            postUrl.current = postUrl.current.replace(postUrl.current[ratingValueIndex], `${round(r)}`)
        }
        let url = `${URL}${postUrl.current}`;
        filterApiRequest(url);
        setStars(round(r));
    };

    const resetData = async () => {
        postUrl.current = "";
        setFilterModal(false);
        let res = await dispatch(getsearchProducts({ access_token, URL: URL }));
        let priceRange = res?.payload?.records?.filterable?.price_range;
        setMin_Price(parseInt(priceRange[0]));
        setMax_Price(parseInt(priceRange[1]));
        setStars(0);
        setSortBy(sortByArray[0]);
    };
    const handleSelectItem = (itemTitle, item, index) => {
        let name1 = item?.slug || item?.name;
        const updProducts = attributeKey.map((name) => {
            for (let n in name) {
                if (n === itemTitle) {
                    return {
                        [n]: {
                            ...name[n],
                            value: name[n].value.map((n2) => {
                                if (
                                    n2.id == index &&
                                    (n2?.slug == name1 || n2.name == name1)
                                ) {
                                    if (name[n].attribute) {
                                        createAttributePostUrl(postUrl, n, n2);
                                    } else {
                                        createFilterablePostUrl(n, postUrl, n2);
                                    }
                                    return {
                                        ...n2,
                                        isChecked: !n2.isChecked,
                                    };
                                } else {
                                    return n2;
                                }
                            }),
                        },
                    };
                } else {
                    return { [n]: name[n] };
                }
            }
        });
        let url = `${URL}${postUrl.current}`;
        filterApiRequest(url);
        setattributeKey(updProducts);
    };
    const handleUpDownIcon = (item) => {
        let updatedAttribute = attributeKey.map((product) => {
            if (Object.keys(product)[0] === item) {
                return {
                    [item]: {
                        ...product[item],
                        status: !product[item].status,
                    },
                };
            } else {
                return product;
            }
        });
        setattributeKey(updatedAttribute);
    };
    const handleUpdatePrice = async () => {
        let key = "&price_range="
        let value = `${minPrice},${maxPrice}`
        let priceRange = `${key}${value}`;
        let priceIndex = postUrl?.current?.indexOf(key);
        if(priceIndex == -1) {
            postUrl.current = postUrl?.current + priceRange
        } else {
            let priceReplaceableIndex = priceIndex + key.length;
            let endIndex = priceReplaceableIndex+value.length
            postUrl.current = replaceStringByRange(postUrl?.current, priceReplaceableIndex, endIndex, value)
        }
        let url = `${URL}${postUrl.current}`;
        filterApiRequest(url);
    };

    const filterApiRequest = async (URL) => {
        try {
            const response = await dispatch(
                getsearchProducts({ access_token, URL })
            );
            const { filterable: updateFilterable, filter_applied } =
                response?.payload?.records;
            let { prop, price_range } = manageFilter(
                updateFilterable,
                URL,
                filter_applied
            );
            setMin_Price(parseInt(price_range[0]));
            setMax_Price(parseInt(price_range[1]));
            setattributeKey(prop);
        } catch (e) {}
    };

    const updateData = async () => {
        setFilterModal(false);
    };

    return (
        <>
            {loading && <InOnScreenLoader />}
            <SafeAreaView>
                <View style={filtersStyles.backNavigation}>
                    <Pressable onPress={() => setFilterModal(false)}>
                        <CustomSVG svgIcon={BackIcon} isRtl={1} style={filtersStyles.iconWrap} height={dpr(28)} width={dpr(28)} />
                    </Pressable>
                    <Text style={filtersStyles.title}>{trans("Filters").toUpperCase()}</Text>
                </View>
            </SafeAreaView>
            <View style={ProfileStyles.hrLine} />
            <KeyboardAvoidingView
                behavior={Platform.OS === "ios" ? "padding" : ""}
                style={filtersStyles.keyboardAvoidingFlex}
            >
                <ScrollView
                    showsVerticalScrollIndicator={false}
                    keyboardShouldPersistTaps="always"
                    style={CommonStyles.cont}
                >
                    <View style={[CommonStyles.globalContainer, gapStyle.mb20]}>
                        <View>
                            {attributeKey.map((item, index) => {
                                return (
                                    <View key={`key${index}`}>
                                        <FilterSelect
                                            item={Object.keys(item)[0]}
                                            show={Object.values(item)[0].status}
                                            handleUpDownIcon={handleUpDownIcon}
                                        />

                                        {Object.values(item)[0].status && (
                                            <SelectBrand
                                                itemTitle={Object.keys(item)[0]}
                                                brands={
                                                    Object.values(item)[0].value
                                                }
                                                handleSelectItem={
                                                    handleSelectItem
                                                }
                                            />
                                        )}
                                        <View style={ProfileStyles.hrLine} />
                                    </View>
                                );
                            })}
                        </View>
                        <View>
                            <Text
                                style={[
                                    filtersStyles.selectText,
                                    gapStyle.mt20,
                                ]}
                            >
                                {trans("Ratings")}
                            </Text>
                        </View>
                        <View style={filtersStyles.ratingCont}>
                            <CustomRating
                                starSize={dpr(22)}
                                rating={parseInt(stars)}
                                onChange={ratingCompleted}
                            />
                            <Text style={filtersStyles.inputText}>
                                {stars === 0
                                    ? trans("Not Selected")
                                    : stars.toFixed(1)}
                            </Text>
                        </View>
                        <View style={ProfileStyles.hrLine} />
                        {price_range?.length > 0 && (
                            <FilterInput
                                minPrice={minPrice}
                                setMin_Price={setMin_Price}
                                maxPrice={maxPrice}
                                setMax_Price={setMax_Price}
                                handleUpdatePrice={handleUpdatePrice}
                            />
                        )}
                    </View>
                </ScrollView>
            </KeyboardAvoidingView>
            <SafeAreaView>
            <View style={Platform.OS === 'ios' ? styles.wrap : EditProfileStyle.changeInfo}>
                <TouchableOpacity onPress={resetData}>
                    <Text style={EditProfileStyle.cancel}>
                        {trans("Reset")}
                    </Text>
                </TouchableOpacity>
                <Pressable
                    onPress={updateData}
                    style={addNewAddressStyle.saveAddressCont}
                >
                    <Text style={addNewAddressStyle.saveAddressBtn}>
                        {trans("Done")}
                    </Text>
                </Pressable>
            </View>
            </SafeAreaView>
        </>
    );
};

export default Filters;

const styles = StyleSheet.create({
    wrap: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        padding: dpr(12),
        width: dpr('wf'),
        zIndex: -999,
    }
});

